unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, StdCtrls, Grids, Calendar, Filectrl, Registry;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    Calendar1: TCalendar;
    Memo1: TMemo;
    ListView1: TListView;
    procedure ReadDay(Day,Month,Year: Integer);
    procedure ReadMonth(Month,Year: Integer);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure Calendar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ReadDay(Day,Month,Year: Integer);
var reg: tregistry;
var key: ansistring;
var datapath: string;
var filetext: string;
var filename: string;
begin
reg := tregistry.create;
reg.rootkey := Hkey_Current_User;
key := ('\Software\Wallie Online\Agenda');
filename := ('');
if reg.openkey(key,false) then
datapath := reg.readstring('Datapath') + ('\');
reg.free;
filetext := inttostr(day)+'-'+inttostr(month)+'-'+inttostr(year);
filename := datapath;
if day < 10 then filename := filename + ('0');
filename := filename + inttostr(day);
if month < 10 then filename := filename + ('0');
filename := filename + inttostr(month);
filename := filename + inttostr(year);
filename := filename + ('.agd');
form1.caption := ('Agenda ' + filetext);
memo1.text := ('No appointment !!!!');
if fileexists(filename) then memo1.lines.loadfromfile(filename);
end;

procedure TForm1.ReadMonth(Month,Year: Integer);
var reg: tregistry;
var key: ansistring;
var datapath: string;
var filetext: string;
var filename: string;
var count1: integer;
var count2: integer;
var mylist: tlistitem;
begin
reg := tregistry.create;
reg.rootkey := Hkey_Current_User;
key := ('\Software\Wallie Online\Agenda');
filename := ('');
if reg.openkey(key,false) then
datapath := reg.readstring('Datapath') + ('\');
reg.free;
listview1.visible := false;
listview1.items.beginupdate;
listview1.items.clear;
for count1 := 1 to 31 do
begin
filetext := inttostr(count1)+'-'+inttostr(month)+'-'+inttostr(year);
filename := datapath;
if count1 < 10 then filename := filename + ('0');
filename := filename + inttostr(count1);
if month < 10 then filename := filename + ('0');
filename := filename + inttostr(month);
filename := filename + inttostr(year);
filename := filename + ('.agd');
if fileexists(filename) then
begin
mylist := listview1.items.add;
mylist.caption := filetext;
mylist.subitems.loadfromfile(filename);
for count2 := 1 to mylist.subitems.count-1 do
mylist.subitems.strings[0] := mylist.subitems.strings[0]+' - '+mylist.subitems.strings[count2];
end;
end;
listview1.items.endupdate;
listview1.visible := true;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
readday(calendar1.day,calendar1.month,calendar1.year);
readmonth(calendar1.month,calendar1.year);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var reg: tregistry;
var key: ansistring;
begin
reg := tregistry.create;
reg.rootkey := Hkey_Current_User;
key := ('\Software\Wallie Online\Agenda');
reg.createkey(key);
if reg.openkey(key,false) then
reg.writeinteger('Winstate',ord(form1.windowstate));
reg.free;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
memo1.width := form1.clientwidth-200;
listview1.width := form1.clientwidth;
listview1.height := form1.clientheight-200;
listview1.columns.items[1].width := form1.clientwidth-104;
end;

procedure TForm1.MenuItem1Click(Sender: TObject);
begin
{NOP}
end;

procedure TForm1.MenuItem2Click(Sender: TObject);
var reg: tregistry;
var key: ansistring;
var dir: string;
begin
reg := tregistry.create;
reg.rootkey := Hkey_Current_User;
key := ('\Software\Wallie Online\Agenda');
if reg.openkey(key,false) then
dir := reg.readstring('Datapath');
reg.free;
if selectdirectory(dir,[sdAllowCreate,sdPerformCreate,sdPrompt],0) then
begin
reg := tregistry.create;
reg.rootkey := Hkey_Current_User;
key := ('\Software\Wallie Online\Agenda');
reg.createkey(key);
if reg.openkey(key,false) then
reg.writestring('Datapath',dir);
reg.free;
end;
end;

procedure TForm1.MenuItem3Click(Sender: TObject);
var designinfo: string;
begin
designinfo := 'Created By Wallie Online.'+#13#10#13#10+'www.wallieonline.nl';
messagedlg(designinfo,mtinformation,[mbok],0);
end;

procedure TForm1.Calendar1Change(Sender: TObject);
begin
readday(calendar1.day,calendar1.month,calendar1.year);
end;

end.
 